/********************************************************************************/
/*																				*/
/*	Kroenke, Auer, Vandenberg & Yoder											*/
/*  Database Concepts (8th Edition) Chapter 08									*/
/*																				*/
/*	Marcia's Dry Cleaning Data Warehouse [MDC-DW] Insert Data 					*/
/*																				*/
/*	Microsoft SQL Server 2016 code solutions									*/
/*																				*/
/********************************************************************************/

/*****  CUSTOMER Data   *********************************************************/

INSERT INTO CUSTOMER VALUES(
		'Kaccaton, Nikki', 'somewhere.com');
INSERT INTO CUSTOMER VALUES(
		'Catnazaro, Brenda', 'somewhere.com');
INSERT INTO CUSTOMER VALUES(
		'LeCat, Bruce', 'somewhere.com');
INSERT INTO CUSTOMER VALUES(
		'Miller, Betsy', 'somewhere.com');
INSERT INTO CUSTOMER VALUES(
		'Miller, George', 'somewhere.com');
INSERT INTO CUSTOMER VALUES(
		'Miller, Kathy', 'somewhere.com');
INSERT INTO CUSTOMER VALUES(
		'Miller, Betsy', 'elsewhere.com');

/*****  SERVICE Data   **********************************************************/

INSERT INTO SERVICE VALUES(10, 'Men''s Shirt');
INSERT INTO SERVICE VALUES(11, 'Dress Shirt');
INSERT INTO SERVICE VALUES(15, 'Women''s Shirt');
INSERT INTO SERVICE VALUES(16, 'Blouse');
INSERT INTO SERVICE VALUES(17, 'Dress Blouse');
INSERT INTO SERVICE VALUES(20, 'SlacksMen''s');
INSERT INTO SERVICE VALUES(25, 'SlacksWomen''s');
INSERT INTO SERVICE VALUES(30, 'Skirt');
INSERT INTO SERVICE VALUES(31, 'Dress Skirt');
INSERT INTO SERVICE VALUES(40, 'SuitMen''s');
INSERT INTO SERVICE VALUES(45, 'SuitWomen''s');
INSERT INTO SERVICE VALUES(50, 'Tuxedo');
INSERT INTO SERVICE VALUES(60, 'Formal Gown');


/*****  ORDER Data   ************************************************************/
INSERT INTO INVOICE VALUES(
		2017001,'04-Oct-17', '06-Oct-17');
INSERT INTO INVOICE VALUES(
		2017002,'04-Oct-17', '06-Oct-17');
INSERT INTO INVOICE VALUES(
		2017003,'06-Oct-17', '08-Oct-17');
INSERT INTO INVOICE VALUES(
		2017004,'06-Oct-17', '08-Oct-17');
INSERT INTO INVOICE VALUES(
		2017005,'07-Oct-17', '11-Oct-17');
INSERT INTO INVOICE VALUES(
		2017006,'11-Oct-17', '13-Oct-17');
INSERT INTO INVOICE VALUES(
		2017007,'11-Oct-17', '13-Oct-17');
INSERT INTO INVOICE VALUES(
		2017008,'12-Oct-17', '14-Oct-17');
INSERT INTO INVOICE VALUES(
		2017009,'12-Oct-17', '14-Oct-17');


/*****  TIMELINE Data   ************************************************************/
-- Note: the TimeID values were computed from a date string using Excel: 
-- =DATEVALUE(04-Oct-2017) is 43012
-- Just need DateIn dates from Invoice

INSERT INTO TIMELINE VALUES(
	43012, '10/04/2017', 10, 'October', 3, 'Qtr3', 2017);
INSERT INTO TIMELINE VALUES(
	43014, '10/06/2017', 10, 'October', 3, 'Qtr3', 2017);
INSERT INTO TIMELINE VALUES(
	43015, '10/07/2015', 10, 'October', 3, 'Qtr3', 2017);
INSERT INTO TIMELINE VALUES(
	43019, '10/11/2017', 10, 'October', 3, 'Qtr3', 2017);
INSERT INTO TIMELINE VALUES(
	43020, '10/12/2017', 10, 'October', 3, 'Qtr3', 2017);

/*****  INVOICE_ITEM Data   ********************************************************/

-- Oct 4 2017 = 43012

INSERT INTO INVOICE_ITEM VALUES(
	43012,	100,	2017001, 16,  7.00);
INSERT INTO INVOICE_ITEM VALUES(
	43012,	100,	2017001,	11,  12.50);
INSERT INTO INVOICE_ITEM VALUES(
	43012,	100,	2017001,	50, 20.00);
INSERT INTO INVOICE_ITEM VALUES(
	43012,	100,	2017001,	20, 50.00);
INSERT INTO INVOICE_ITEM VALUES(
	43012,	100,	2017001,	25, 60.00);
INSERT INTO INVOICE_ITEM VALUES(
	43012,	100,	2017001,	40, 9.00);
INSERT INTO INVOICE_ITEM VALUES(
	43012,	105,	2017002,	11, 25.00);

-- Oct 06 2017 =  43014

INSERT INTO INVOICE_ITEM VALUES(
	43014,	100,	2017003,	20, 25.00);
INSERT INTO INVOICE_ITEM VALUES(
	43014,	100,	2017003,	25, 24.00);
INSERT INTO INVOICE_ITEM VALUES(
	43014,	115,	2017004,	11, 7.50);

-- Oct 07 2017 = 43015

INSERT INTO INVOICE_ITEM VALUES(
	43015,	125,	2017005,	16, 7.00);
INSERT INTO INVOICE_ITEM VALUES(
	43015,	125,	2017005,	11, 5.00);

-- Oct 11 2017 = 43019

INSERT INTO INVOICE_ITEM VALUES(
	43019,	110,	2017006,	16, 17.50);
INSERT INTO INVOICE_ITEM VALUES(
	43019,	110,	2017006,	11, 25.00);
INSERT INTO INVOICE_ITEM VALUES(
	43019,	110,	2017006,	20, 50.00);
INSERT INTO INVOICE_ITEM VALUES(
	43019,	110,	2017006,	25, 60.00);
INSERT INTO INVOICE_ITEM VALUES(
	43019,	110,	2017007,	16, 7.00);

-- Oct 12 2017 = 43020

INSERT INTO INVOICE_ITEM VALUES(
	43020,	130,	2017008,	16, 10.50);
INSERT INTO INVOICE_ITEM VALUES(
	43020,	130,	2017008,	11, 30.00);
INSERT INTO INVOICE_ITEM VALUES(
	43020,	130,	2017008,	20, 40.00);
INSERT INTO INVOICE_ITEM VALUES(
	43020,	130,	2017008,	25, 60.00);
INSERT INTO INVOICE_ITEM VALUES(
	43020,	120,	2017009,	40, 27.00);

/*********************************************************************************/




